# Copyright (C) 2013-2023 Echelon Corporation.  All Rights Reserved.
# Use of this code is subject to your compliance with the terms of the
# Echelon IzoT(tm) Software Developer's Kit License Agreement which is
# available at www.echelon.com/license/izot_sdk/.

# IzoT resources contained in this file are generated by an automated
# database to source code conversion process.  Grammar and punctuation within
# the embedded documentation may not be correct, as this data is gathered and
# combined from several sources.
# Names of resources and fields or members defined within a resource are
# derived from the same sources.  Names, capitalization and aspects of source
# code formatting may fail to comply with PEP-8 and PEP-257 recommendations
# due to the automated generation of these IzoT definitions.
# Generated at 11-May-2023 17:11.

"""SerialNumber userdefined property type, originally defined in resource
file set apollodev 90:00:01:06:00:00:00:00-4."""


import izot.resources.base
from P9000010600000000_4.userdefined import userdefined


class SerialNumber(izot.resources.base.Structure):
    """SerialNumber userdefined property type.  ."""

    def __init__(self):
        super().__init__(
            key=18,
            scope=4
        )

        self.__SN = izot.resources.base.Array(
            [
                izot.resources.base.Scaled(
                    size=1,
                    signed=False,
                    minimum=0,
                    maximum=255
                ) for i in range(12)
            ]
        )
        self._register(('SN', self.__SN))
        self._default_bytes = b'\x30\x30\x30\x30\x30\x30\x30\x30\x30\x30\x30' \
            b'\x30'
        self._original_name = 'UCPTSerialNumber'
        self._property_scope, self._property_key = 4, 18
        self._definition = userdefined.add(self)

    def __set_SN(self, v):
        self.__SN._value = v

    SN = property(
        lambda self: self.__SN._value,
        __set_SN,
        None,
        """."""
    )

    def __len__(self):
        """Return the length of the type, in bytes."""
        return 12


if __name__ == '__main__':
    # unit test code.
    item = SerialNumber()
    pass
